/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.util;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.dialogs.GenericInfoPopupDialog;
import com.aptana.ui.util.Messages;
import com.aptana.ui.util.SafeMessageDialogRunnable;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.services.IEvaluationService;

public final class UIUtils {
    private static final String HELP_VIEW_ID = "org.eclipse.help.ui.HelpView";
    public static final int DEFAULT_TOOLTIP_TIME = 3000;
    private static final String INTERNAL_HELP_BROWSER_ID = "internal_help_browser";

    private UIUtils() {
    }

    public static Display getDisplay() {
        return PlatformUI.getWorkbench().getDisplay();
    }

    public static Shell getActiveShell() {
        IWorkbenchWindow window;
        Shell shell = UIUtils.getDisplay().getActiveShell();
        if (shell == null && (window = UIUtils.getActiveWorkbenchWindow()) != null) {
            shell = window.getShell();
        }
        return shell;
    }

    public static IEditorPart getActiveEditor() {
        IWorkbenchPage workbenchPage = UIUtils.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        return workbenchPage.getActiveEditor();
    }

    public static IWorkbenchPart getActivePart() {
        IWorkbenchPage workbenchPage = UIUtils.getActivePage();
        if (workbenchPage == null) {
            return null;
        }
        return workbenchPage.getActivePart();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow workbench = UIUtils.getActiveWorkbenchWindow();
        if (workbench == null) {
            return null;
        }
        return workbench.getActivePage();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        try {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        }
        catch (IllegalStateException e) {
            return null;
        }
    }

    public static String getActivePerspectiveId() {
        IPerspectiveDescriptor perspective = UIUtils.getActivePerspectiveDescriptor();
        if (perspective != null) {
            return perspective.getId();
        }
        return null;
    }

    public static IPerspectiveDescriptor getActivePerspectiveDescriptor() {
        IWorkbenchPage activePage = UIUtils.getActivePage();
        if (activePage != null) {
            return activePage.getPerspective();
        }
        return null;
    }

    public static IEditorPart[] getDirtyEditors() {
        IWorkbenchPage page = UIUtils.getActivePage();
        if (page == null) {
            return null;
        }
        return page.getDirtyEditors();
    }

    public static URI getURI(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getLocationURI();
        }
        if (input instanceof IURIEditorInput) {
            return ((IURIEditorInput)input).getURI();
        }
        if (input instanceof IPathEditorInput) {
            return URIUtil.toURI((IPath)((IPathEditorInput)input).getPath());
        }
        return null;
    }

    public static IResource getSelectedResource() {
        IEvaluationService evaluationService = (IEvaluationService)PlatformUI.getWorkbench().getService(IEvaluationService.class);
        if (evaluationService != null) {
            return UIUtils.getSelectedResource(evaluationService.getCurrentState());
        }
        return null;
    }

    public static IProject getSelectedProjectInExplorer() {
        IProject selectedProject = UIUtils.getSelectedProject("com.aptana.explorer.view");
        if (selectedProject == null) {
            selectedProject = UIUtils.getSelectedProject("org.eclipse.ui.navigator.ProjectExplorer");
        }
        return selectedProject;
    }

    private static IProject getSelectedProject(String viewID) {
        IResource resource;
        Object selectedObject;
        ISelectionService service = UIUtils.getActiveWorkbenchWindow().getSelectionService();
        IStructuredSelection structured = (IStructuredSelection)service.getSelection(viewID);
        if (structured instanceof IStructuredSelection && (selectedObject = structured.getFirstElement()) instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class)) != null) {
            return resource.getProject();
        }
        return null;
    }

    public static IResource getSelectedResource(IEvaluationContext evaluationContext) {
        if (evaluationContext == null) {
            return null;
        }
        Object variable = evaluationContext.getVariable("selection");
        if (variable instanceof IStructuredSelection) {
            IResource resource;
            Object selectedObject = ((IStructuredSelection)variable).getFirstElement();
            if (selectedObject instanceof IAdaptable && (resource = (IResource)((IAdaptable)selectedObject).getAdapter(IResource.class)) != null) {
                return resource;
            }
        } else {
            IEditorInput editorInput;
            variable = evaluationContext.getVariable("activeEditor");
            if (variable instanceof IEditorPart && (editorInput = ((IEditorPart)variable).getEditorInput()) instanceof IFileEditorInput) {
                return ((IFileEditorInput)editorInput).getFile();
            }
        }
        return null;
    }

    public static IProject getSelectedProject() {
        IProject project = null;
        IResource selectedResource = UIUtils.getSelectedResource();
        if (selectedResource != null) {
            project = selectedResource.getProject();
        }
        return project;
    }

    public static IViewPart findView(String viewID) {
        IWorkbenchPage page = UIUtils.getActivePage();
        if (page != null) {
            return page.findView(viewID);
        }
        return null;
    }

    public static boolean showView(String viewID) {
        return UIUtils.showView(viewID, 1);
    }

    public static boolean showView(String viewID, int mode) {
        IWorkbenchPage activePage = UIUtils.getActivePage();
        if (activePage != null) {
            try {
                return activePage.showView(viewID, null, mode) != null;
            }
            catch (PartInitException e) {
                return false;
            }
        }
        return false;
    }

    public static void showErrorMessage(String title, String message) {
        UIUtils.showErrorMessage(title != null ? title : Messages.UIUtils_Error, message, null);
    }

    public static void showErrorMessage(String message, Throwable exception) {
        UIUtils.showErrorMessage(Messages.UIUtils_Error, message, exception);
    }

    private static void showErrorMessage(final String title, final String message, final Throwable exception) {
        if (Display.getCurrent() == null || exception != null) {
            UIJob job = new UIJob(message){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (exception == null) {
                        UIUtils.showErrorDialog(title, message);
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.aptana.ui", null, exception);
                }
            };
            job.setPriority(10);
            job.setUser(true);
            job.schedule();
        } else {
            UIUtils.showErrorDialog(title, message);
        }
    }

    public static void showMessageDialogFromBgThread(final int kind, final String title, final String message, final ISafeRunnable runnable) {
        UIUtils.showMessageDialogFromBgThread(new SafeMessageDialogRunnable(){

            public void run() throws Exception {
                if (runnable != null) {
                    runnable.run();
                }
            }

            public int openMessageDialog() {
                if (kind == 2) {
                    IWorkbenchWindow window = UIUtils.getActiveWorkbenchWindow();
                    if (window == null) {
                        return 1;
                    }
                    GenericInfoPopupDialog dialog = new GenericInfoPopupDialog(window.getShell(), title, message);
                    return dialog.open();
                }
                return MessageDialog.open((int)kind, (Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)title, (String)message, (int)0) ? 0 : 1;
            }
        }, 0);
    }

    public static void showMessageDialogFromBgThread(SafeMessageDialogRunnable runnable) {
        UIUtils.showMessageDialogFromBgThread(runnable, 0);
    }

    public static void showMessageDialogFromBgThread(final SafeMessageDialogRunnable runnable, final int runnableCondition) {
        UIJob job = new UIJob("Modal Message Dialog Job"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (Display.getDefault().getActiveShell() == null) {
                    if (!monitor.isCanceled()) {
                        this.schedule(1000L);
                    }
                } else if (!monitor.isCanceled() && runnable.openMessageDialog() == runnableCondition) {
                    try {
                        runnable.run();
                    }
                    catch (Exception e) {
                        IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        EclipseUtil.setSystemForJob((Job)job);
        job.schedule();
    }

    private static void showErrorDialog(String title, String message) {
        MessageDialog.openError((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public static void showErrorDialog(Shell shell, String title, String message) {
        MessageDialog.openError((Shell)shell, (String)title, (String)message);
    }

    public static boolean showPromptDialog(final String title, final String message) {
        if (Display.getCurrent() == null) {
            UIJob job = new UIJob(title){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (UIUtils.showPromptDialogUI(title, message)) {
                        return Status.OK_STATUS;
                    }
                    return Status.CANCEL_STATUS;
                }
            };
            job.setPriority(10);
            job.setUser(true);
            job.schedule();
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return job.getResult() == Status.OK_STATUS;
        }
        return UIUtils.showPromptDialogUI(title, message);
    }

    private static boolean showPromptDialogUI(String title, String message) {
        return MessageDialog.openQuestion((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public static Image getImage(AbstractUIPlugin plugin, String path) {
        ImageRegistry registry = plugin.getImageRegistry();
        Image image = registry.get(path);
        if (image == null) {
            ImageDescriptor id = UIUtils.getImageDescriptor(plugin.getBundle().getSymbolicName(), path);
            if (id == null) {
                return null;
            }
            registry.put(path, id);
            image = registry.get(path);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String pluginId, String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)pluginId, (String)path);
    }

    public static boolean getCoolBarVisibility() {
        IWorkbenchWindow activeWorkbenchWindow;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null && (activeWorkbenchWindow = UIUtils.getActiveWorkbenchWindow()) instanceof WorkbenchWindow) {
            return ((WorkbenchWindow)activeWorkbenchWindow).getCoolBarVisible();
        }
        return true;
    }

    public static void setCoolBarVisibility(boolean visible) {
        IWorkbenchWindow activeWorkbenchWindow = UIUtils.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow instanceof WorkbenchWindow) {
            WorkbenchWindow workbenchWindow = (WorkbenchWindow)activeWorkbenchWindow;
            workbenchWindow.setCoolBarVisible(visible);
            workbenchWindow.setPerspectiveBarVisible(visible);
            IWorkbenchPart activePart = UIUtils.getActivePart();
            if (activePart != null) {
                ICommandService cmdService = (ICommandService)activePart.getSite().getService(ICommandService.class);
                cmdService.refreshElements("org.eclipse.ui.ToggleCoolbarAction", null);
            }
        }
    }

    public static void openHelp(String url) {
        IWorkbenchPage page = UIUtils.getActivePage();
        if (page != null) {
            try {
                IViewPart part = page.showView(HELP_VIEW_ID);
                if (part != null) {
                    HelpView view = (HelpView)part;
                    view.showHelp(url);
                }
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (Throwable)e);
            }
        } else {
            IdeLog.logWarning((Plugin)UIPlugin.getDefault(), (String)"Could not open the help view. Active page was null.");
        }
    }

    public static boolean openHelpInBrowser(String url) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchHelpSystem helpSystem = workbench.getHelpSystem();
            URL resolvedURL = helpSystem.resolve(url, true);
            if (resolvedURL != null) {
                return UIUtils.openInBroswer(resolvedURL, true, 40);
            }
            IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)("Unable to resolve the Help URL for " + url));
            return false;
        }
        return false;
    }

    public static boolean openInBroswer(URL url, boolean internal, int style) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench != null) {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            try {
                if (internal && support.isInternalWebBrowserAvailable()) {
                    support.createBrowser(style, INTERNAL_HELP_BROWSER_ID, null, null).openURL(url);
                } else {
                    support.getExternalBrowser().openURL(url);
                }
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)UIPlugin.getDefault(), (String)"Error opening the help", (Throwable)e);
                return false;
            }
            return true;
        }
        return false;
    }

    public static void runInUIThread(Runnable runnable) {
        Display display = Display.getCurrent();
        if (display == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static String shortenText(String text, int width) {
        GC gc = new GC((Drawable)UIUtils.getDisplay());
        int middle = text.length() / 2;
        String beginning = text.substring(0, middle - 1);
        String end = text.substring(middle + 2, text.length());
        while (gc.stringExtent((String)new StringBuilder((String)String.valueOf((Object)beginning)).append((String)"...").append((String)end).toString()).x > width) {
            if (beginning.length() <= 0) break;
            beginning = beginning.substring(0, beginning.length() - 1);
            if (end.length() <= 0) break;
            end = end.substring(1);
        }
        text = String.valueOf(beginning) + "..." + end;
        return text;
    }

    public static void assertUIThread() {
        Assert.isTrue((Display.getCurrent() != null ? 1 : 0) != 0, (String)"Function must be called from UI-thread.");
    }

    public static void restartStudio(final String title, final String message) {
        UIUtils.showMessageDialogFromBgThread(new SafeMessageDialogRunnable(){

            public int openMessageDialog() {
                boolean restart = MessageDialog.openQuestion((Shell)UIUtils.getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
                if (restart) {
                    PlatformUI.getWorkbench().restart();
                }
                return 0;
            }
        });
    }

    public static void closeStudio(String title, String message, String productId) {
        MessageDialog.openError((Shell)UIUtils.getActiveShell(), (String)title, (String)message);
        if (EclipseUtil.getPluginVersion((String)productId) != null && !EclipseUtil.isTesting()) {
            PlatformUI.getWorkbench().close();
        }
    }
}

